﻿namespace Microsoft.Samples.PlanMyNight.Web.Helpers.Tests
{
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class ItineraryExtensionFixture
    {
        [TestMethod]
        public void ItineraryCalculatesTotalTime()
        {
            var itinerary = new Itinerary();
            itinerary.Activities.Add(new ItineraryActivity { EstimatedMinutes = 15 });
            itinerary.Activities.Add(new ItineraryActivity { EstimatedMinutes = 30 });

            Assert.AreEqual(45, itinerary.TotalEstimatedMinutes);
        }

        [TestMethod]
        public void ItineraryCalculatesTotalTimeWhenNoActivities()
        {
            var itinerary = new Itinerary();

            Assert.AreEqual(0, itinerary.TotalEstimatedMinutes);
        }
    }
}
